// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for writing and reading encrypted message via the clipboard.
//........................................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include <Mapi.h>
#include <richedit.h>
#include <string.h>
#include <ole2.h>
//#include <ssce.h>
#include "zlib.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD			dwStringSafeFlag;
extern	HWND			hMainWindow;
extern	HINSTANCE		hInst;
extern	LPCTSTR			lpszNullString;
extern	BOOL			bProcessInProgress;
extern	HANDLE			hComposeEvent;
extern	HANDLE			hComposeOpen;
extern	HANDLE			hReadEvent;
extern	HANDLE			hReadOpen;
extern	DWORD			dwComposeNote;
extern	LPTSTR			lpszNA;
extern	PARAFORMAT2		pf;
extern	CHARFORMAT2		cf;
extern	LPCTSTR			lpszAppName;
extern	LPCTSTR			lpIconPointer;
extern	BOOL			bNoTextClr;
extern	BOOL			bUseSentrySpellChecker;
extern	COLORREF		crSetBkgColor;
extern	BOOL			bDeleteReplyFile;
extern	DWORD			dwMyReplyFormat;
extern	TCHAR			szMyReplyFile[MAX_PATH];
extern	COLORREF		crOleBkg;
extern	COLORREF		crBkgCurrent;
extern	BOOL			bReturnReceipt;
extern	BOOL			bChooseBkgColor;
extern	CHOOSECOLOR		crBkg;
extern	CHOOSECOLOR		crText;
extern	COLORREF		crTextCurrent;
extern	BOOL			bHaveRichEdit3;
extern	DWORD			dwSpellHelp;
extern	TCHAR			szCheckSpellingDlg;
extern	TCHAR			szEditLexDlg;
extern	TCHAR			szOptionsDlg;
extern	TCHAR			szNewLexDlg;
extern	BOOL			bTempRtf;
extern	HANDLE			hDlgCurrent;
extern	UINT			uComDlgHelpMsg;
extern	UINT			uFindMsgString;
extern	LPFINDREPLACE	lpFr;
extern	TCHAR			szFileToEncipher[MAX_PATH];
extern	BOOL			bFromChat;
extern	TCHAR			szInsertBuffer[256];
extern	HWND			hCurrentRtfWnd;
extern	BOOL			bIncludeBkgClr;
extern	LARGE_INTEGER	liEncFileSize;
extern	BOOL			bUseMd5;
extern	TCHAR			szPkdRtfFile[MAX_PATH];
extern	LPBYTE			lpInBuffer;
extern	MSG_HEADER		Msghdr;
extern	BYTE			MessageId[];
extern	z_stream		z;
extern  LPBYTE			lpOutBuffer;
extern	BOOL			bCanceledMsgEncryption;
extern	TCHAR			szDestination[MAX_PATH];
extern	LPTSTR			lpszClipboard;
extern	BOOL			bEncryptingEmail;
extern	BOOL			bProgramRegistered;
extern	TCHAR			Header1[];
extern	TCHAR			Header1P[];
extern	TCHAR			Footer1[];
extern	TCHAR			szClipboardRtf[];
extern	BOOL			bSendErrToClipboard;
extern	CONFIG			cfg;
extern	HCURSOR			hCursorArrow;
extern	TCHAR			szMyRichEditCtrl[16];
extern	BOOL			bHaveRichEdit41orGreater;

// Variables for the procedure.
//.............................
LPCTSTR				lpWrite640 = "COMPOSECLIP640";
LPCTSTR				lpWrite800 = "COMPOSECLIP800";
LPCTSTR				lpWrite1024 = "COMPOSECLIP1024";

LPCTSTR				lpReadClip640 = "READMESSAGECLIP640";
LPCTSTR				lpReadClip800 = "READMESSAGECLIP800";
LPCTSTR				lpReadClip1024 = "READMESSAGECLIP1024";

LPCTSTR				lpWrite640New = "COMPOSECLIP640NEW";
LPCTSTR				lpWrite800New = "COMPOSECLIP800NEW";
LPCTSTR				lpWrite1024New = "COMPOSECLIP1024NEW";

LPCTSTR				lpReadClip640New = "READMESSAGECLIP640NEW";
LPCTSTR				lpReadClip800New = "READMESSAGECLIP800NEW";
LPCTSTR				lpReadClip1024New = "READMESSAGECLIP1024NEW";

TCHAR	szMessage9[] = "Your message was successfully encrypted and placed in the clipboard. You can paste the encrypted message into any e-mail program.";
TCHAR	szMessage10[] = "Your message was NOT successfully encrypted and placed into the clipboard.";

BOOL				bReplyToClipMessage;
BOOL				bDecryptReadClip;
UINT				uDecryptReadFormat;
BOOL				bNoDecryptErr;
TCHAR				szMessageRtf[] = "Message.rtf";

// Write, encrypt and send contents to clipboard.
//...............................................
VOID WriteEncryptClipboard()
{
	DWORD					dwOldHelpTopic;
	HANDLE					hRtf = 0;
	int						i;
	LPCTSTR					lpDialogBox;
	HWND					hCompose = 0;
	
	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(IDH_WRITEENCRYPTCLIP);

	if (BPC())
	{
		goto WriteEnd;
	}
	// Load the rich text edit dll.
	//.............................
	hRtf = LoadLibrary((LPCTSTR)&szMyRichEditCtrl);
	if (!hRtf)
	{
		ErrorProcedure((LPTSTR)&szMyRichEditCtrl,IDS_LOADLIBRARY,MB_OK);
		goto WriteEnd;
	}
	// Write your message.
	//....................
	dwComposeNote = 1;
	EmptyTheMessageQue();

	// Create an event for our compose e-mail message dialog box.
	//...........................................................
	hComposeEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("ComposeEvent"));
	if (!hComposeEvent)
	{
		ErrorProcedure(TEXT("ComposeEvent"),IDS_CREATEEVENT,MB_OK);
		goto WriteEnd;
	}
	// Get the current screen size so we can display the correct
	// dialog box.
	//..........................................................
	i = GetSystemMetrics(SM_CXFULLSCREEN);
			
	if (bHaveRichEdit41orGreater)
	{
		if (i >= 950)
		{
			lpDialogBox = lpWrite1024New;
		}
		else if (i >= 750)
		{
			lpDialogBox = lpWrite800New;
		}
		else
		{
			lpDialogBox = lpWrite640New;
		}
	}
	else
	{
		if (i >= 950)
		{
			lpDialogBox = lpWrite1024;
		}
		else if (i >= 750)
		{
			lpDialogBox = lpWrite800;
		}
		else
		{
			lpDialogBox = lpWrite640;
		}
	}
	// Create the dialog box.
	//.......................
	hCompose = CreateDialog(hInst,lpDialogBox,hMainWindow,(DLGPROC)WriteNoteProc);

	if (hCompose == NULL)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto WriteEnd;
	}
	EmptyTheMessageQue();

	// Open our event and wait.
	//.........................
	hComposeOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("ComposeEvent"));
	if (!hComposeOpen)
	{
		DestroyWindow(hCompose);
		goto WriteEnd;
	}
	// We have to wait for the Edit Event to become signaled before
	// we can return and process the selections from the Central
	// Directory.
	//.............................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hComposeEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}
	if (dwComposeNote == IDC_MSGENCRYPT)
	{
		// Here is where we encrypt the contents of the e-mail.
		//.....................................................
		EncryptMessageToClipboard();
	}

	WriteEnd:

	EmptyTheMessageQue();

	if (hComposeOpen)
	{
		CloseHandle(hComposeOpen);
		hComposeOpen = 0;
	}
	if (hComposeEvent)
	{
		CloseHandle(hComposeEvent);
		hComposeEvent = 0;
	}
	if (hRtf)
	{
		FreeLibrary(hRtf);
	}
	dwComposeNote = 0;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for the Writing, Encrypting, and Sending to clipboard.
//..........................................................................
LRESULT CALLBACK WriteNoteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL					bResult;
	BOOL					bFatalErr = TRUE;
    LONG					cb;
	LONG					cLines;
	BOOL					bErr;
	int						iAttrib;
	int						iDlgResult;
	UINT					uCheck;
	CHARRANGE				cr;
	DWORD					dwParaHelp;
	int						iResult;

	cf.cbSize = sizeof(CHARFORMAT2);
	pf.cbSize = sizeof(PARAFORMAT2);

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// The text color button is disabled on entry.
			//............................................
			bNoTextClr = TRUE;
			dwComposeNote = 0;

			// If we did not initialize the spell checker, gray its button.
			//.............................................................
			if (!bUseSentrySpellChecker)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_SPELLCHECK),FALSE);
			}
			// Setup the rich text edit control.
			//..................................
			SendDlgItemMessage(hDlg,IDC_NOTE,EM_AUTOURLDETECT,(WPARAM)TRUE,0);
			SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXLIMITTEXT,0,FIVEMEGABYTES);

			// Setup event notification.
			//..........................
			SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETEVENTMASK,0,
							  (LPARAM)ENM_KEYEVENTS | ENM_MOUSEEVENTS | ENM_LINK);

			// Setup ole callback.
			//....................
			SetupOleCallback(hDlg,IDC_NOTE);

			if (bReplyToClipMessage)
			{
				// Make sure the old background color is saved in case we
				// respond to a message before composing one.
				//.......................................................
				crSetBkgColor = cfg.savecf.crBackColor;

				// If we are replying to a message we have to read in
				// the rich text from a file.
				//...................................................
				if (dwMyReplyFormat == 0)
				{
					iAttrib = SF_RTF;
				}
				else
				{
					iAttrib = SF_TEXT;
				}
				bErr = OpenFileStreamIn((LPTSTR)&szMyReplyFile,hDlg,IDC_NOTE,iAttrib);
					
				if (bErr)
				{
					goto cleanup;
				}
				SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETSEL,(WPARAM)0,(LPARAM)0);
					
				// Let's insert the original message at the beginning.
				//....................................................
				SendDlgItemMessage(hDlg,IDC_NOTE,EM_REPLACESEL,(WPARAM)TRUE,
								  (LPARAM)TEXT("\r\n-----Original Message-----\r\n\r\n"));
				SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETSEL,(WPARAM)0,(LPARAM)0);

				// Set the current background color for the rich edit control.
				//............................................................
				SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETBKGNDCOLOR,0,
								  (LPARAM)(COLORREF)crBkgCurrent);
				crOleBkg = crBkgCurrent;
				bReplyToClipMessage = FALSE;

				// Tell the control it has not been modified.
				//...........................................
				SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETMODIFY,FALSE,0);

				// Set the focus on the proper control.
				//.....................................
				SetFocus(GetDlgItem(hDlg,IDC_NOTE));
			}
			else
			{
				SetFocus(GetDlgItem(hDlg,IDC_NOTE));

				// Lets setup the character formating.
				//....................................
				cf.cbSize = sizeof(CHARFORMAT2);
				if (!cfg.savecf.cbSize)
				{
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,0,(LPARAM)&cf);
					CopyMemory(&cfg.savecf,&cf,sizeof(CHARFORMAT2));
					cfg.savecf.crBackColor = crBkgCurrent;
					crOleBkg = crBkgCurrent;
				}
				else
				{
					CopyMemory(&cf,&cfg.savecf,sizeof(CHARFORMAT2));
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETBKGNDCOLOR,0,
								      (LPARAM)(COLORREF)cf.crBackColor);
					crBkgCurrent = cf.crBackColor;
					crSetBkgColor = cf.crBackColor;
					crOleBkg = cf.crBackColor;
					EnableWindow(GetDlgItem(hDlg,IDC_TEXTCLR),TRUE);
					bNoTextClr = FALSE;
				}
				SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_ALL,(LPARAM)&cf);
			}
			// Setup the initial paragraph alignment depending on what is set.
			//................................................................
			pf.cbSize = sizeof(PARAFORMAT2);
			SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETPARAFORMAT,0,(LPARAM)&pf);

			// Set the return request radiobutton as appropriate.
			//...................................................
			if (bReturnReceipt)
			{
				CheckDlgButton(hDlg,IDC_RETURN,BST_CHECKED);
			}
			else
			{
				CheckDlgButton(hDlg,IDC_RETURN,BST_UNCHECKED);
			}
			// Update the radio buttons.
			//..........................
			UpdateRtfRadioButtons(hDlg,IDC_NOTE);

			// Center the dialog box.
			//.......................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return FALSE;
		}

		case WM_NOTIFY:
		{
			LPNMHDR			lpNmhdr;
			LPMSGFILTER		lpMsgFilter;
			LPENLINK		pEnlink;
			LPBYTE			lpLink;
			DWORD			dwLinkSize;
			CHARRANGE		range;

			lpNmhdr = (LPNMHDR)lParam;
			lpMsgFilter = (LPMSGFILTER)lParam;
			pEnlink = (LPENLINK)lParam;

			switch(lpNmhdr->code) 
			{
				case EN_MSGFILTER:
				{
					if (lpNmhdr->idFrom == IDC_NOTE)
					{
						if (lpMsgFilter->msg == WM_LBUTTONUP || lpMsgFilter->msg == WM_KEYUP)
						{
							UpdateRtfRadioButtons(hDlg,lpNmhdr->idFrom);
						}
					}
				}
				break;

				case EN_LINK:
				{
					if (lpNmhdr->code == EN_LINK)
					{
						if (pEnlink->msg == WM_LBUTTONUP)
						{
							// Get the range and allocate the buffer.
							//.......................................
							dwLinkSize = pEnlink->chrg.cpMax - pEnlink->chrg.cpMin;
							if (dwLinkSize)
							{
								lpLink = AllocateMemory(dwLinkSize + 10);
								if (lpLink)
								{
									SetCursor(hCursorArrow);
									range.cpMax = pEnlink->chrg.cpMax;
									range.cpMin = pEnlink->chrg.cpMin;

									SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXSETSEL,0,
													  (LPARAM)(CHARRANGE FAR *)&range);
									SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETSELTEXT,0,
												      (LPARAM)lpLink);
									ShellExecute(NULL,"open",(LPCTSTR)lpLink,NULL,NULL,
												 SW_SHOWNORMAL);
									range.cpMin = -1;
									SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXSETSEL,0,
													  (LPARAM)(CHARRANGE FAR *)&range);
									DeallocateMemory(lpLink);
								}
							}
						}
					}
				}
				break;
			}
		}
		break;

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_FONT:
				{
					SelectCharFormat(hDlg,GetDlgItem(hDlg,IDC_NOTE),(LPBYTE)&cfg.savecf);
				}
				break;

				case IDC_BKG:
				{
					ZeroMemory(&crBkg,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;
					bChooseBkgColor = TRUE;

					crBkg.lStructSize = sizeof(CHOOSECOLOR);
					crBkg.hwndOwner = hDlg;
					crBkg.rgbResult = crBkgCurrent;
					crBkg.lpCustColors = (LPDWORD)cfg.crBkgCustom;
					crBkg.lpfnHook = MyCCHookProc;
					crBkg.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crBkg))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// We have a valid color selection.
						//.................................
						crBkgCurrent = crBkg.rgbResult;
						crSetBkgColor = crBkg.rgbResult;
						crOleBkg = crBkg.rgbResult;

						SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETBKGNDCOLOR,0,
										  (LPARAM)(COLORREF)crBkgCurrent);
					}
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_TEXTCLR:
				{
					ZeroMemory(&crText,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;
					bChooseBkgColor = FALSE;

					crText.lStructSize = sizeof(CHOOSECOLOR);
					crText.hwndOwner = hDlg;
					crText.rgbResult = crTextCurrent;
					crText.lpCustColors = (LPDWORD)cfg.crTextCustom;
					crText.lpfnHook = MyCCHookProc;
					crText.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crText))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// We have a valid color selection.
						//.................................
						crTextCurrent = crText.rgbResult;

						// Get the current font information from the rich edit control.
						//.............................................................
						SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,
								          (LPARAM)&cf);
						cf.crTextColor = crTextCurrent;
						SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,
										  (LPARAM)&cf);

						SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXGETSEL,0,(LPARAM)&cr);

						// Only save the new text color if it pertains to the
						// whole control and not just a selection.
						//...................................................
						if (cr.cpMax == cr.cpMin)
						{
							// Save the text color selection.
							//...............................
							CopyMemory(&cfg.savecf,&cf,sizeof(CHARFORMAT2));
						}
					}
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_BOLD:
				{
					// Toggle the bold effect.
					//........................
					cf.dwMask = CFM_BOLD;
					SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
					cf.dwEffects ^= CFE_BOLD;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,
									  (LPARAM)&cf);

					// Now we have to toggle the bold radiobutton.
					//............................................
					uCheck = IsDlgButtonChecked(hDlg,IDC_BOLD);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
					}
					else
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_BOLD,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_ITALIC:
				{
					// Toggle the bold effect.
					//........................
					cf.dwMask = CFM_ITALIC;
					SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
					cf.dwEffects ^= CFE_ITALIC;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,
									  (LPARAM)&cf);

					// Now we have to toggle the bold radiobutton.
					//............................................
					uCheck = IsDlgButtonChecked(hDlg,IDC_ITALIC);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
					}
					else
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_ITALIC,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_UNDERLINE:
				{
					// Toggle the bold effect.
					//........................
					cf.dwMask = CFM_UNDERLINE | CFM_UNDERLINETYPE;
					SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
					cf.dwEffects ^= CFE_UNDERLINE;
					
					// If we have rich edit 3.0 or greater we can select the
					// type of underline we have if we are setting it.
					//......................................................
					if (bHaveRichEdit3 && (cf.dwEffects & CFE_UNDERLINE))
					{
						EnableWindow(hDlg,FALSE);

						iDlgResult = DialogBox(hInst,TEXT("SELECTUNDERLINE"),hDlg,
											  (DLGPROC)SelectUnderlineProc);
						EnableWindow(hDlg,TRUE);

						// See if we had a system error in creating the dialog box.
						//.........................................................
						if (iDlgResult == -1)
						{
							ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);	
							SetFocus(GetDlgItem(hDlg,IDC_NOTE));
							break;
						}
						// Quit if we canceled.
						//.....................
						if (iDlgResult == IDCANCEL)
						{
							SetFocus(GetDlgItem(hDlg,IDC_NOTE));
							break;
						}

					}
					// Send the style to the rich text edit window.
					//.............................................
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,
									  (LPARAM)&cf);

					// Now we have to toggle the bold radiobutton.
					//............................................
					uCheck = IsDlgButtonChecked(hDlg,IDC_UNDERLINE);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
					}
					else
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_UNDERLINE,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_LEFT:
				{
					pf.dwMask = PFM_ALIGNMENT;
					pf.wAlignment = PFA_LEFT;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,IDC_LEFT);
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_CENTER:
				{
					pf.dwMask = PFM_ALIGNMENT;
					pf.wAlignment = PFA_CENTER;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,IDC_CENTER);
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_RIGHT:
				{
					pf.dwMask = PFM_ALIGNMENT;
					pf.wAlignment = PFA_RIGHT;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,IDC_RIGHT);
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_BULLETS:
				{
					pf.dwMask = PFM_NUMBERING;
					if (IsDlgButtonChecked(hDlg,IDC_BULLETS))
					{
						pf.wNumbering = 0;
						uCheck = BST_UNCHECKED;
					}
					else
					{	
						// If we have Richedit 3.0 or above we can select bullets
						// and styles.
						//.......................................................
						if (bHaveRichEdit3)
						{
							pf.cbSize = sizeof(PARAFORMAT2);
							SendMessage(GetDlgItem(hDlg,IDC_NOTE),EM_GETPARAFORMAT,0,
												  (LPARAM)&pf);

							EnableWindow(hDlg,FALSE);

							iDlgResult = DialogBox(hInst,TEXT("BULLETS"),hDlg,
												   (DLGPROC)BulletsProc);
							// See if we had a system error in creating the dialog box.
							//.........................................................
							if (iDlgResult == -1)
							{
								ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
								EnableWindow(hDlg,TRUE);
								SetFocus(GetDlgItem(hDlg,IDC_NOTE));
								break;
							}
							// Quit if we canceled.
							//.....................
							if (iDlgResult == IDCANCEL)
							{
								EnableWindow(hDlg,TRUE);
								SetFocus(GetDlgItem(hDlg,IDC_NOTE));
								break;
							}
							pf.wNumberingStart = 1;
							if (pf.wNumbering > PFN_BULLET)
							{
								pf.dwMask = (PFM_NUMBERING | PFM_NUMBERINGSTART | PFM_NUMBERINGSTYLE | 
										     PFM_NUMBERINGTAB | PFM_OFFSET | PFM_STARTINDENT);
							}
							else
							{
								pf.dwMask = PFM_NUMBERING;
							}
							EnableWindow(hDlg,TRUE);
						}
						else
						{
							pf.wNumbering = PFN_BULLET;
						}
						uCheck = BST_CHECKED;
					}
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					pf.cbSize = sizeof(PARAFORMAT2);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckDlgButton(hDlg,IDC_BULLETS,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_SMILEYSCLIP:
				{
					hCurrentRtfWnd = GetDlgItem(hDlg,IDC_NOTE);
					bFromChat = FALSE;
					GetMySmileys();
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_FORMATCLIP:
				{
					pf.cbSize = sizeof(PARAFORMAT2);
					SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETPARAFORMAT,0,(LPARAM)&pf);

					dwParaHelp = ChangeHelpTopic(IDH_FORMAT_PARAGRAPH);

					iResult = DialogBox(hInst,TEXT("FORMATPARAGRAPH"),hDlg,
								       (DLGPROC)FormatParagraphProc);
					if (iResult == IDOK)
					{
						pf.dwMask = PFM_LINESPACING | PFM_OFFSET | PFM_STARTINDENT | 
									PFM_RIGHTINDENT | PFM_SPACEBEFORE | PFM_SPACEAFTER;
						pf.cbSize = sizeof(PARAFORMAT2);
				
						SendDlgItemMessage(hDlg,IDC_NOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					}
					ChangeHelpTopic(dwParaHelp);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_DATECLIP:
				{
					dwParaHelp = ChangeHelpTopic(IDH_INSERTDATETIME);

					iResult = DialogBox(hInst,TEXT("DATETIMEPICKER"),hDlg,
							           (DLGPROC)DateTimePickerProc);
					if (iResult == IDOK)
					{
						SendDlgItemMessage(hDlg,IDC_NOTE,EM_REPLACESEL,TRUE,
										  (LPARAM)&szInsertBuffer);
					}
					ChangeHelpTopic(dwParaHelp);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_RETURN:
				{
					if (IsDlgButtonChecked(hDlg,IDC_RETURN))
					{
						bReturnReceipt = FALSE;
						uCheck = BST_UNCHECKED;
					}
					else
					{
						bReturnReceipt = TRUE;
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_RETURN,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;

				case IDC_SPELLCHECK:
				{
//					SHORT		sError;

					dwSpellHelp = ChangeHelpTopic(IDH_SPELL_CHECKER);

					// Determine if we only have a selection to test.
					//...............................................
//					SendDlgItemMessage(hDlg,IDC_NOTE,EM_EXGETSEL,0,(LPARAM)&cr);

//					if (cr.cpMax == cr.cpMin)
//					{
//						sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,GetDlgItem(hDlg,IDC_NOTE),
//														FALSE,hInst,&szCheckSpellingDlg,
//														&szEditLexDlg,&szOptionsDlg,
//														&szNewLexDlg);
//					}
//					else
//					{
//						sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,GetDlgItem(hDlg,IDC_NOTE),
//														TRUE,hInst,&szCheckSpellingDlg,
//														&szEditLexDlg,&szOptionsDlg,
//														&szNewLexDlg);
//					}
//					SentrySpellError(sError);
//					SetUserLexiconFiles();
//					EmptyTheMessageQue();
					SetFocus(GetDlgItem(hDlg,IDC_NOTE));
					ChangeHelpTopic(dwSpellHelp);
				}
				break;

				case IDC_MSGENCRYPT:
				{
					// Disable the dialog box. We are encrypting or sending.
					//......................................................
					EnableWindow(hDlg,FALSE);

					// We are extracting the rich text content into a file.
					//.....................................................
					bTempRtf = FALSE;

					cb = 0;
					cLines = SendDlgItemMessage(hDlg,IDC_NOTE,EM_GETLINECOUNT,0,0L);

					if (cLines)
					{
						// Get the total number of bytes in the multi-line.
						//.................................................
						cb = SendDlgItemMessage(hDlg,IDC_NOTE,EM_LINEINDEX,
											   (UINT)cLines - 1,0L);
						cb += SendDlgItemMessage(hDlg,IDC_NOTE,EM_LINELENGTH,(UINT)cb,0L);
					}
					if (cb)
					{
						// Get the rich text data into a temporary file.
						//..............................................
						bResult = CreateFileStreamOut((LPTSTR)&szFileToEncipher,hDlg,IDC_NOTE,SF_RTF,TRUE);
						if (!bResult)
						{
							goto cleanup;
						}
						bTempRtf = TRUE;
					}
					else
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_MAPI_NOTEXT,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						EnableWindow(hDlg,TRUE);
						SetFocus(GetDlgItem(hDlg,IDC_NOTE));
						break;
					}
					// No fatal errors at this point.
					//...............................
					bFatalErr = FALSE;

					cleanup:

					EnableWindow(hDlg,TRUE);
				}
				
				case IDCANCEL:
				{
					// Make sure we save any background color we set.
					//...............................................
					cfg.savecf.crBackColor = crSetBkgColor;

					// Set the control in the dialog box to an empty string.
					//......................................................
					SendDlgItemMessage(hDlg,IDC_NOTE,WM_SETTEXT,0,(LPARAM)lpszNullString);

					// Only deallocate the memory if we have sent the message
					// or cancelled or have a fatal error.
					//.......................................................
					if (LOWORD(wParam) == IDCANCEL || bFatalErr)
					{
						if (!bFatalErr)
						{
							dwComposeNote = LOWORD(wParam);
						}
						else
						{
							dwComposeNote = 1;
						}
						DestroyWindow(hDlg);
					}
					else if (LOWORD(wParam) == IDC_MSGENCRYPT)
					{
						dwComposeNote = IDC_MSGENCRYPT;
						DestroyWindow(hDlg);
					}
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			HWND		hControl;
			
			hControl = GetDlgItem(hDlg,IDC_NOTE);

			if (hControl == (HWND)wParam)
			{
				RtfContextMenu(hDlg,(HWND)wParam,lParam,IDC_NOTE);
			}
			else
			{
				WhatsThis(hDlg,(HWND)wParam,lParam);
			}
		}
		break;

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			// Notify the compose note procedure that it can
			// continue.
			//..............................................
			SetEvent(hComposeEvent);
		}
		break;

		default:
		{
			if (uiMsg == uComDlgHelpMsg && uComDlgHelpMsg)
			{
				DisplayMyHelp(hDlg);
			}
			else if (uiMsg == uFindMsgString && uFindMsgString)
			{
				lpFr = (LPFINDREPLACE)lParam;
				MyFindDlgBox();
			}
			else
			{
				return(FALSE);
			}
			break;
		}
	}
	return(TRUE);
}

// Encrypt the message and place it in the clipboard.
//...................................................
BOOL EncryptMessageToClipboard()
{
	BOOL			bErr = TRUE;
	BOOL			bError;
	BOOL			bResult;
	BOOL			bWeHavePkd = FALSE;
	int				iResult;
	int				iError;
	HANDLE			hDestFile = 0;
	HANDLE			hEncFile = 0;
	HANDLE			hTempFile = 0;
	BOOL			bDeleteDest = FALSE;
	BOOL			bInit = FALSE;
	BOOL			bMem;
	DWORD			dwErrCode;
	BOOL			bClipOpen = FALSE;
	HANDLE			hClipboard;
	LARGE_INTEGER	li;
	LARGE_INTEGER	liPkdFileSize;
	ULARGE_INTEGER	uli;
	OPENFILENAME	ofn;
	DWORD			dwSize;	
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	DWORD			dwArmorLines;
	DWORD			dwMemNeeded;
	DWORD			dwCurrentSize;
	int				iTemp;
	UINT			uRealFormatUsed = 0;
	HANDLE			lpClipboardMem = 0;
	HANDLE			lpClipboardMemDup;
	HGLOBAL			hClipboardMem;
	LPBYTE			lpEncryptedBuffer = 0;
	TCHAR			szFormatString[256];
	TCHAR			szBuffer[512];

	InitializeOFN(&ofn,SAVE_SOURCE);

	// We want to include the background color in the armor file.
	//...........................................................
	bIncludeBkgClr = TRUE;

	// Check out the file's size. We do not want to encipher a
	// zero length file.
	//........................................................
	hEncFile = CreateMyFile((LPTSTR)&szFileToEncipher,GENERIC_READ,0,NULL,OPEN_EXISTING,
							 FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hEncFile)
	{
		goto EncryptEnd;
	}
	liEncFileSize.QuadPart = GetMyFileSize((LPTSTR)&szFileToEncipher,hEncFile);
	liPkdFileSize.QuadPart = liEncFileSize.QuadPart;
	if (liEncFileSize.QuadPart == -1)
	{
		goto EncryptEnd;
	}
	if (!bUseMd5)
	{
		// Compress the file if we are not in the old protocols.
		// First of all, setup the pkd file.
		//..................................
		CopyMemory(&szPkdRtfFile,&szFileToEncipher,MAX_PATH);
		PathRemoveExtension((LPTSTR)&szPkdRtfFile);
		StringCbCatEx((LPTSTR)&szPkdRtfFile,sizeof(szPkdRtfFile),TEXT(".pkd"),NULL,NULL,
					   dwStringSafeFlag);

		// Create the ouput file.
		//.......................
		hTempFile = CreateMyFile((LPTSTR)&szPkdRtfFile,GENERIC_READ | GENERIC_WRITE,
								  0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hTempFile)
		{
			goto EncryptEnd;
		}
		// Setup the size of the input and output buffers.
		//................................................	
		lpInBuffer = AllocateMemory(liEncFileSize.LowPart);

		if (!lpInBuffer)
		{
			goto EncryptEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szFileToEncipher,hEncFile,lpInBuffer,
						      liEncFileSize.LowPart,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		// Setup the compressed message header.
		//.....................................
		CopyMemory(&Msghdr.MsgId,&MessageId,4);
		Msghdr.dwMsgSize = liEncFileSize.LowPart;

		// Do the crc32 for the file.
		//...........................
		Msghdr.dwMsgCrc32 = crc32(0L,Z_NULL,0);
		Msghdr.dwMsgCrc32 = crc32(Msghdr.dwMsgCrc32,lpInBuffer,liEncFileSize.LowPart);

		// Setup the z_stream.
		//....................
		ZeroMemory(&z,sizeof(z));

		// Initialize the internal stream state for compression.
		//......................................................
		iError = deflateInit(&z,Z_BEST_COMPRESSION);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATEINIT);
			goto EncryptEnd;
		}
		bInit = TRUE;

		uli.HighPart = 0;
		uli.LowPart = deflateBound(&z,liEncFileSize.LowPart);

		lpOutBuffer = AllocateMemory(uli.LowPart);

		if (!lpOutBuffer)
		{
			goto EncryptEnd;
		}
		z.avail_in = liEncFileSize.LowPart;
		z.avail_out = uli.LowPart;
		z.next_in = lpInBuffer;
		z.next_out = lpOutBuffer;

		// Lets go and compress this message.
		//...................................
		iError = deflate(&z,Z_FINISH);
		if (iError < 0)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATE);
			goto EncryptEnd;
		}
		if (iError != Z_STREAM_END)
		{
			ZlibError((LPBYTE)&szFileToEncipher,Z_DATA_ERROR,IDS_DEFLATE);
			goto EncryptEnd;
		}
		iError = deflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATEEND);
			goto EncryptEnd;
		}
		bInit = FALSE;

		Msghdr.dwCompressedMsgSize = z.total_out;

		// Write the header to disk.
		//..........................
		bResult = WriteMyFile((LPTSTR)&szPkdRtfFile,hTempFile,&Msghdr,sizeof(Msghdr),
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		bResult = WriteMyFile((LPTSTR)&szPkdRtfFile,hTempFile,lpOutBuffer,z.total_out,
							   &dwBytesWritten,NULL);
		if(!bResult)
		{
			goto EncryptEnd;
		}
		// Get the new size of the packed file.
		//.....................................
		liEncFileSize.QuadPart = GetMyFileSize((LPTSTR)&szPkdRtfFile,hTempFile);

		bResult = CloseMyHandle((LPTSTR)&szPkdRtfFile,hTempFile);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		bWeHavePkd = TRUE;
		hTempFile = 0;
	}

	bResult = CloseMyHandle((LPTSTR)&szFileToEncipher,hEncFile);
	if (!bResult)
	{
		goto EncryptEnd;
	}
	hEncFile = 0;

	// If we have a valid packed file, we encrypt it.
	//...............................................
	if (bWeHavePkd)
	{
		SwapOps((LPBYTE)&szFileToEncipher,(LPBYTE)&szPkdRtfFile,MAX_PATH);
	}
	// Setup and call the encryption procedure.
	//.........................................
	bEncryptingEmail = TRUE;
	bError = EncryptAFile((LPBYTE)&szFileToEncipher,&ofn);
	bEncryptingEmail = FALSE;

	// Wipe the intermediate packed file and swap the names back.
	//...........................................................
	if (bWeHavePkd)
	{
		WipeMyFile((LPBYTE)&szFileToEncipher,TRUE);
		SwapOps((LPBYTE)&szFileToEncipher,(LPBYTE)&szPkdRtfFile,MAX_PATH);
	}
	// If we have an error and did not cancel.
	//.......................................
	if (bError && !bCanceledMsgEncryption)
	{
		goto EncryptEnd;
	}
	// If no error and we did not cancel, setup the encypted text to put in the clipboard.
	//....................................................................................
	if (!bError && !bCanceledMsgEncryption)
	{
		// Get the size of the file and allocate a buffer.
		//................................................
		hDestFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ,0,NULL,
								  OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hDestFile)
		{
			goto EncryptEnd;
		}
		bDeleteDest = TRUE;

		li.QuadPart = GetMyFileSize((LPTSTR)&szDestination,hDestFile);
		if (li.QuadPart == -1)
		{
			goto EncryptEnd;
		}
		dwSize = li.LowPart;
		lpEncryptedBuffer = AllocateMemory(dwSize);
		if (!lpEncryptedBuffer)
		{
			goto EncryptEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szDestination,hDestFile,lpEncryptedBuffer,
							dwSize,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		bResult = CloseMyHandle((LPTSTR)&szDestination,hDestFile);
		if (!bResult)
		{
			goto EncryptEnd;
		}
		hDestFile = 0;

		// Figure out the memory needed for the armor buffer.
		//...................................................
		__asm
		{
			xor		edx,edx
			mov		eax,dwSize
			mov		ecx,48
			div		ecx
			cmp		edx,0
			je		L1
			inc		eax
		L1:	mov		dwArmorLines,eax
		}
		dwMemNeeded = ((dwArmorLines * 66) + 1024);
		dwCurrentSize = dwMemNeeded;
		hClipboardMem = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,dwMemNeeded);
		if (hClipboardMem == NULL)
		{
			ErrorProcedure((LPTSTR)lpszClipboard,IDS_ALLOCATEMEMORY,MB_OK);
			goto EncryptEnd;
		}
		lpClipboardMem = GlobalLock(hClipboardMem);
		if (lpClipboardMem == NULL)
		{
			ErrorProcedure((LPTSTR)lpszClipboard,IDS_LOCKMEMORY,MB_OK);
			GlobalFree(hClipboardMem);
			goto EncryptEnd;
		}
		ZeroMemory(lpClipboardMem,dwMemNeeded);

		// Put in the header.
		//...................
		lpClipboardMemDup = lpClipboardMem;
		ZeroMemory(&szBuffer,sizeof(szBuffer));
		if (bProgramRegistered)
		{
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&Header1,
						    uRealFormatUsed);
		}
		else
		{
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&Header1P,
						    uRealFormatUsed);
		}
		CopyMemory(lpClipboardMemDup,&szBuffer,lstrlen((LPCTSTR)&szBuffer));
		iTemp = lstrlen((LPCTSTR)&szBuffer);
		__asm
		{
			mov		ecx,iTemp
			mov		edi,lpClipboardMemDup
			add		edi,ecx
			mov		lpClipboardMemDup,edi
		}
		// Armor the buffer.
		//..................
		lpClipboardMemDup = ArmorBuffer(lpEncryptedBuffer,lpClipboardMemDup,dwSize);

		// Put in the footer.
		//...................
		CopyMemory(lpClipboardMemDup,&Footer1,lstrlen((LPCTSTR)&Footer1));

		// Clear the encrypted buffer.
		//............................
		ZeroMemory(lpEncryptedBuffer,dwSize);
		DeallocateMemory(lpEncryptedBuffer);
		lpEncryptedBuffer = 0;
		
		// Unlock the memory for the clipboard.
		//.....................................
		bMem = GlobalUnlock(hClipboardMem);
		if (!bMem)
		{
			dwErrCode = GetLastError();
			if (dwErrCode != NO_ERROR)
			{
				SetLastError(dwErrCode);
				ErrorProcedure(lpszClipboard,IDS_UNLOCKMEMORY,MB_OK);
				goto EncryptEnd;
			}
		}
		// Open the Clipboard.
		//....................
		bResult = OpenClipboard(hMainWindow);
		if (!bResult)
		{
			ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
			goto EncryptEnd;
		}
		bClipOpen = TRUE;

		bResult = EmptyClipboard();
		if (!bResult)
		{
			ErrorProcedure(lpszClipboard,IDS_EMPTYCLIPBOARD,MB_OK);
			goto EncryptEnd;
		}
		hClipboard = SetClipboardData(CF_TEXT,hClipboardMem);
		if (!hClipboard)
		{
			ErrorProcedure(lpszClipboard,IDS_SETCLIPBOARD,MB_OK);
			goto EncryptEnd;
		}
		bResult = CloseClipboard();

		ZeroMemory(&szBuffer,sizeof(szBuffer));

		if (bResult)
		{
			CopyMemory(&szBuffer,&szMessage9,sizeof(szMessage9));
			bClipOpen = FALSE;
		}
		else
		{
			CopyMemory(&szBuffer,&szMessage10,sizeof(szMessage10));
		}
		MessageBoxProc(hMainWindow,IDS_CLOSECLIPBOARD,(UINT)&szBuffer,
					   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
		
		bErr = FALSE;
	}
	else
	{
		// We cancelled encryption of a message before it was done. Ask if we want
		// to save the original file to use again.
		//........................................................................
		LoadString(hInst,IDS_ASKSAVEMSG,(LPTSTR)&szFormatString,sizeof(szFormatString));
		StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szFormatString,
						szFileToEncipher);
		iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)szBuffer,
								 MB_ICONQUESTION | MB_HELP | MB_YESNO,MB_ICONQUESTION,0);
		if (iResult == IDYES)
		{
			bTempRtf = FALSE;
		}
	}

	EncryptEnd:

	bIncludeBkgClr = FALSE;

	if (bInit)
	{
		iError = deflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szFileToEncipher,iError,IDS_DEFLATEEND);
			bResult = FALSE;
		}
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,uli.LowPart);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,liPkdFileSize.LowPart);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (hEncFile)
	{
		CloseMyHandle((LPTSTR)&szFileToEncipher,hEncFile);
	}
	if (bTempRtf)
	{
		WipeMyFile((LPBYTE)&szFileToEncipher,TRUE);	
		bTempRtf = FALSE;
	}
	if (hDestFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hDestFile);
	}
	if (bDeleteDest)
	{
		WipeMyFile((LPBYTE)&szDestination,TRUE);
	}
	if (lpEncryptedBuffer)
	{
		ZeroMemory(lpEncryptedBuffer,dwSize);
		DeallocateMemory(lpEncryptedBuffer);
	}
	return(bErr);
}

// Decrypt and read clipboard in rtf window.
//..........................................
VOID DecryptReadClipboard()
{
	HGLOBAL			hGlobal;
	BOOL			bResult;
	BOOL			bClipOpen;
	LPBYTE			lpClipboard = 0;
	LPBYTE			lpMyClipboard = 0;
	DWORD			dwLength;
	HANDLE			hFile;
	DWORD			dwBytesWritten;
	DWORD			dwOldHelpTopic;
	int				i;
	LPCTSTR			lpDialogBox;
	HWND			hReadBox = 0;
	HANDLE			hRtf = 0;
	BOOL			bClipErr;
	BOOL			bWipeReplyFile = FALSE;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_DECRYPTREADCLIP);

	// Load the rich text edit dll.
	//.............................
	hRtf = LoadLibrary((LPCTSTR)&szMyRichEditCtrl);
	if (!hRtf)
	{
		ErrorProcedure((LPTSTR)&szMyRichEditCtrl,IDS_LOADLIBRARY,MB_OK);
		goto DecryptEnd;
	}
	// Decrypt the message in the clipboard.
	//......................................
	bDecryptReadClip = TRUE;
	bNoDecryptErr = FALSE;
	DecryptTheClipboard();
	bDecryptReadClip = FALSE;

	EmptyTheMessageQue();

	if (!bNoDecryptErr)
	{
		goto DecryptEnd;
	}
	// Get the decrypted clipboard data and put it in a file.
	//.......................................................
	bResult = OpenClipboard(hMainWindow);
	if (!bResult)
	{
		ErrorProcedure(lpszClipboard,IDS_OPENCLIPBOARD,MB_OK);
		goto DecryptEnd;
	}
	bClipOpen = TRUE;

	// Get the clipboard data.
	//........................
	hGlobal = GetClipboardData(uDecryptReadFormat);
	if (!hGlobal)
	{
		ErrorProcedure(lpszClipboard,IDS_GETCLIPBOARD,MB_OK);
		goto DecryptEnd;
	}
	lpMyClipboard = GlobalLock(hGlobal);
	if (!lpMyClipboard)
	{
		ErrorProcedure(lpszClipboard,IDS_LOCKMEMORY,MB_OK);
		goto DecryptEnd;
	}
	// Get the length of the clipboard so we can allocate our own memory block.
	//.........................................................................
	dwLength = (lstrlen((LPCTSTR)lpMyClipboard) + 1);

	lpClipboard = AllocateMemory(dwLength);
	if (!lpClipboard)
	{
		goto DecryptEnd;
	}
	// Copy the clipboard to our memory block.
	//........................................
	CopyMemory(lpClipboard,lpMyClipboard,dwLength);
	ZeroMemory(lpMyClipboard,dwLength);
	GlobalUnlock(hGlobal);
	EmptyClipboard();
	CloseClipboard();
	bClipOpen = FALSE;

	// Save the decrypted information in a temporary file.
	//....................................................
	ZeroMemory(&szMyReplyFile,sizeof(szMyReplyFile));
	GetTempPath(MAX_PATH,(LPTSTR)&szMyReplyFile);
	StringCbCatEx((LPTSTR)&szMyReplyFile,sizeof(szMyReplyFile),(LPCTSTR)&szMessageRtf,NULL,
				   NULL,dwStringSafeFlag);

	hFile = CreateMyFile((LPTSTR)&szMyReplyFile,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,
						 FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile)
	{
		goto DecryptEnd;
	}
	bResult = WriteMyFile((LPTSTR)&szMyReplyFile,hFile,lpClipboard,dwLength,&dwBytesWritten,
						  NULL);
	if (!bResult)
	{
		goto DecryptEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szMyReplyFile,hFile);
	if (!bResult)
	{
		goto DecryptEnd;
	}
	hFile = 0;
	bWipeReplyFile = TRUE;

	dwComposeNote = 1;
	EmptyTheMessageQue();

	// Create an event for our read rtf window.
	//.........................................
	hReadEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("ReadEvent"));
	if (!hReadEvent)
	{
		ErrorProcedure(TEXT("ReadEvent"),IDS_CREATEEVENT,MB_OK);
		goto DecryptEnd;
	}
	// Determine the current display resolution.
	//..........................................
	i = GetSystemMetrics(SM_CXFULLSCREEN);

	// Display the dialog box to read a message with depending
	// on the current screen resolution.
	//........................................................
	if (bHaveRichEdit41orGreater)
	{
		if (i >= 950)
		{
			lpDialogBox = lpReadClip1024New;
		}
		else if (i >= 750)
		{
			lpDialogBox = lpReadClip800New;
		}
		else
		{
			lpDialogBox = lpReadClip640New;
		}
	}
	else
	{
		if (i >= 950)
		{
			lpDialogBox = lpReadClip1024;
		}
		else if (i >= 750)
		{
			lpDialogBox = lpReadClip800;
		}
		else
		{
			lpDialogBox = lpReadClip640;
		}
	}
	hReadBox = CreateDialog(hInst,lpDialogBox,hMainWindow,(DLGPROC)DecryptReadProc);
	if (hReadBox == NULL)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto DecryptEnd;
	}
	// We have to wait for a reply from the read message box.
	//.......................................................
	hReadOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("ReadEvent"));
	if (!hReadOpen)
	{
		DestroyWindow(hReadBox);
		goto DecryptEnd;
	}
	while(TRUE)
	{
		if (WaitForSingleObject(hReadEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}
	// If we fall through to here with dwComposeNote equal to IDC_MSGENCRYPT.
	//.......................................................................
	if (dwComposeNote == IDC_MSGENCRYPT)
	{
		EncryptMessageToClipboard();
	}

	DecryptEnd:

	if (bWipeReplyFile)
	{
		bClipErr = bSendErrToClipboard;
		bSendErrToClipboard = FALSE;

		// Wipe the original decrypted file.
		//..................................
		WipeMyFile((LPBYTE)&szMyReplyFile,TRUE);

		bSendErrToClipboard = bClipErr;
	}
	EmptyTheMessageQue();

	if (hReadOpen)
	{
		CloseHandle(hReadOpen);
		hReadOpen = 0;
	}
	if (hReadEvent)
	{
		CloseHandle(hReadEvent);
		hReadEvent = 0;
	}
	// Close the clipboard.
	//.....................
	if (bClipOpen)
	{
		CloseClipboard();
	}
	if (lpClipboard)
	{
		ZeroMemory(lpClipboard,dwLength);
		DeallocateMemory(lpClipboard);
	}
	if (hRtf)
	{
		FreeLibrary(hRtf);
	}
	dwComposeNote = 0;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for reading the contents of a message.
//..........................................................
LRESULT CALLBACK DecryptReadProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	int				iAttrib;
	BOOL			bErr;
	int				i;
	LPCTSTR			lpDialogBox;
	HWND			hCompose = 0;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Center the dialog box.
			//.......................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));

			// Setup the rich text edit control.
			//..................................
			SendDlgItemMessage(hDlg,IDC_RNOTE,EM_AUTOURLDETECT,(WPARAM)TRUE,0);
			SendDlgItemMessage(hDlg,IDC_RNOTE,EM_SETEVENTMASK,0,ENM_LINK);

			// Setup ole callback.
			//....................
			SetupOleCallback(hDlg,IDC_RNOTE);

			if (dwMyReplyFormat == 0)
			{
				iAttrib = SF_RTF;
			}
			else
			{
				iAttrib = SF_TEXT;
			}
			bErr = OpenFileStreamIn((LPTSTR)&szMyReplyFile,hDlg,IDC_RNOTE,iAttrib);
					
			if (bErr)
			{
				DestroyWindow(hDlg);
				return(TRUE);
			}
			SendDlgItemMessage(hDlg,IDC_RNOTE,EM_SETSEL,(WPARAM)0,(LPARAM)0);

			// Set the current background color for the rich edit control.
			//............................................................
			SendDlgItemMessage(hDlg,IDC_RNOTE,EM_SETBKGNDCOLOR,0,
					          (LPARAM)(COLORREF)crBkgCurrent);

			SetFocus(GetDlgItem(hDlg,IDC_MYCLOSE));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_REPLY:
				{
					// Disable our dialog box.
					//........................
					ShowWindow(hDlg,SW_HIDE);
					EnableWindow(hDlg,FALSE);

					bReplyToClipMessage = TRUE;

					// Create an event for answering this message.
					//............................................
					hComposeEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("ComposeEvent"));
					if (!hComposeEvent)
					{
						ErrorProcedure(TEXT("ComposeEvent"),IDS_CREATEEVENT,MB_OK);
						break;
					}
					// Get the current screen size so we can display the correct
					// dialog box.
					//..........................................................
					i = GetSystemMetrics(SM_CXFULLSCREEN);

					if (bHaveRichEdit41orGreater)
					{
						if (i >= 950)
						{
							lpDialogBox = lpWrite1024New;
						}
						else if (i >= 750)
						{
							lpDialogBox = lpWrite800New;
						}
						else
						{
							lpDialogBox = lpWrite640New;
						}
					}
					else
					{
						if (i >= 950)
						{
							lpDialogBox = lpWrite1024;
						}
						else if (i >= 750)
						{
							lpDialogBox = lpWrite800;
						}
						else
						{
							lpDialogBox = lpWrite640;
						}
					}
					hCompose = CreateDialog(hInst,lpDialogBox,hMainWindow,
										   (DLGPROC)WriteNoteProc);
					if (hCompose == NULL)
					{
						ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
						goto BackToReadBox;
					}
					EmptyTheMessageQue();

					// Open our event and wait.
					//.........................
					hComposeOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("ComposeEvent"));
					if (!hComposeOpen)
					{
						DestroyWindow(hCompose);
						goto BackToReadBox;
					}
					while(TRUE)
					{
						if (WaitForSingleObject(hComposeEvent,0) == WAIT_OBJECT_0)
						{
							break;
						}
						EmptyTheMessageQue();
					}
					if (hComposeOpen)
					{
						CloseHandle(hComposeOpen);
						hComposeOpen = 0;
					}
					if (hComposeEvent)
					{
						CloseHandle(hComposeEvent);
						hComposeEvent = 0;
					}
					if (dwComposeNote == IDCANCEL)
					{
						dwComposeNote = 0;
						goto BackToReadBox;
					}
					if (dwComposeNote == IDC_MSGENCRYPT)
					{
						DestroyWindow(hDlg);
						break;
					}

				  BackToReadBox:

					SetupOleCallback(hDlg,IDC_RNOTE);

					if (hComposeOpen)
					{
						CloseHandle(hComposeOpen);
						hComposeOpen = 0;
					}
					if (hComposeEvent)
					{
						CloseHandle(hComposeEvent);
						hComposeEvent = 0;
					}
					ShowWindow(hDlg,SW_SHOW);
					EnableWindow(hDlg,TRUE);
					SendDlgItemMessage(hDlg,IDC_RNOTE,EM_SETSEL,(WPARAM)0,(LPARAM)0);
					SetFocus(GetDlgItem(hDlg,IDC_RNOTE));
				}
				break;

				case IDC_MYCLOSE:
				case IDCANCEL:
				{
					dwComposeNote = 0;
					DestroyWindow(hDlg);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;

		case WM_NOTIFY:
		{
			LPENLINK	pEnlink;
			LPNMHDR		lpNmhdr;
			LPBYTE		lpLink;
			DWORD		dwLinkSize;
			CHARRANGE	range;

			pEnlink = (LPENLINK)lParam;
			lpNmhdr = (LPNMHDR)lParam;

			if (lpNmhdr->code == EN_LINK)
			{
				if (pEnlink->msg == WM_LBUTTONUP)
				{
					// Get the range and allocate the buffer.
					//.......................................
					dwLinkSize = pEnlink->chrg.cpMax - pEnlink->chrg.cpMin;
					if (dwLinkSize)
					{
						lpLink = AllocateMemory(dwLinkSize + 10);
						if (lpLink)
						{
							SetCursor(hCursorArrow);
							range.cpMax = pEnlink->chrg.cpMax;
							range.cpMin = pEnlink->chrg.cpMin;

							SendDlgItemMessage(hDlg,IDC_RNOTE,EM_EXSETSEL,0,
											  (LPARAM)(CHARRANGE FAR *)&range);
							SendDlgItemMessage(hDlg,IDC_RNOTE,EM_GETSELTEXT,0,(LPARAM)lpLink);
							ShellExecute(NULL,"open",(LPCTSTR)lpLink,NULL,NULL,SW_SHOWNORMAL);
							range.cpMin = -1;
							SendDlgItemMessage(hDlg,IDC_RNOTE,EM_EXSETSEL,0,
											  (LPARAM)(CHARRANGE FAR *)&range);
							DeallocateMemory(lpLink);
						}
					}
				}
			}
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			HWND		hControl;
			
			hControl = GetDlgItem(hDlg,IDC_RNOTE);
			if (hControl == (HWND)wParam)
			{
				ReadContextMenu(hDlg,(HWND)wParam,lParam);
			}
			else
			{
				WhatsThis(hDlg,(HWND)wParam,lParam);
			}
		}
		break;

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			// Notify the read window procedure to continue.
			//..............................................
			SetEvent(hReadEvent);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}
